import React, { useEffect, useRef, useState } from "react";
import { useNavigate, Link } from "react-router-dom";
import MainSiteHeader from "../../components/MainSiteHeader";
import MainSiteFooter from "../../components/MainSiteFooter";
import HomeAnchor from "../../assets/img/home/homepage-anchor.jpg";
import Lifestyle1 from "../../assets/img/home/homepage-lifestyle-1.jpg";
import Lifestyle2 from "../../assets/img/home/homepage-lifestyle-2.jpg";
import Lifestyle3 from "../../assets/img/home/homepage-lifestyle-3.jpg";
import Sophistication from "../../assets/img/home/homepage-sophistication.jpg";
import Inspire from "../../assets/img/home/homepage-inspire.jpg";
import Style from "../../assets/img/home/homepage-style.jpg";
import SquareFrame from "../../assets/img/home/homepage-squareframe.svg";
import ActiveDot from "../../assets/img/home/homepage-slider-menu-navy.svg";
import Dot from "../../assets/img/home/homepage-slider-menu-beidge.svg";

const Home = () => {
  const handleView = () => {

	};
	useEffect(() => {
		window.addEventListener('load', handleView);
		window.addEventListener('resize', handleView);
		return () => {
			window.removeEventListener('load', handleView);
			window.removeEventListener('resize', handleView);
		};
	}, []);
  return (
    <div className="w-full">
		<MainSiteHeader />		
		<div className="w-full relative flex flex-col-reverse lg:flex-row items-center pb-[50px] bg-white z-[1]">
			<div className="hidden lg:block w-[10%]">
			</div>
			<div className="w-full lg:w-[50%] grid grid-cols-3 gap-2">
				<div className="pt-[50px] lg:pt-0">
					<img src={Lifestyle1}></img>
				</div>
				<div>
					<img src={Lifestyle2}></img>
				</div>
				<div className="pt-[50px] lg:pt-0">
					<img src={Lifestyle3}></img>
				</div>
			</div>
			<div className="w-full lg:w-[30%] p-[25px] lg:p-[50px]">
				<h2 className="lg:hidden">Designed for Better Living</h2>
				<br className="lg:hidden"></br>
				<h3 className="lg:hidden">1 to 3 Bed Townhomes & Garden Suites</h3>
				<br className="lg:hidden"></br>
				<br className="lg:hidden"></br>
				<p>Charming yet vibrant. Connected yet tranquil. Modern yet timeless. Enter West58, a dynamic collection of 23 spacious townhomes and garden suites perfectly crafted to embody the essence of living well in a setting that truly stands out. Enveloped by serene parks, green spaces and a network of top-tier schools in Vancouver’s west side, West58 is where life’s best elements converge in one place.</p>
				<br></br>
				<Link to="/neighbourhood"><h3>Explore Our Neighbourhood &#8594;</h3></Link>
				<br className="lg:hidden"></br>
				<br className="lg:hidden"></br>
			</div>
			<div className="hidden lg:block w-[10%]">
			</div>
		</div>
		<div className="w-full relative overflow-clip">
			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip ">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Designed for
							<br></br>
							Sophistication
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>Life at West58 welcomes you to a home where function and style unite, and where roomy interiors and intuitive layouts create the perfect backdrop for a thriving lifestyle.</p>
					<br></br>
					<Link to="/homes"><h3>Explore Our Homes &#8594;</h3></Link>
				</div>
				<div className="hidden lg:block absolute right-0 w-full lg:w-[50vw] h-[300%] top-[25%] lg:top-0">
					<div className="sticky h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] bottom-0 lg:top-[7.8vw] flex items-center">
						<img className="" src={Sophistication}></img>
					</div>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Sophistication}></img>
						</div>
					</div>
				</div>
				</div>

			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip ">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Designed to
							<br></br>
							Style
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>Embrace the refined interiors of West58, curated for both comfort and style. With generous storage, abundant natural light and sophisticated design touches, West58 creates the perfect canvas for modern living.</p>
					<br></br>
					<Link to="/gallery"><h3>Explore to Gallery &#8594;</h3></Link>
				</div>
				<div className="hidden lg:block absolute right-0 w-full lg:w-[50vw] h-[300%] top-[25%] lg:top-0">
					<div className="sticky h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] bottom-0 lg:top-[7.8vw] flex items-center">
						<img className="" src={Style}></img>
					</div>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Style}></img>
						</div>
					</div>
				</div>
			</div>

			<div className="w-full relative lg:flex items-center h-[calc(100vh-18vw)] lg:h-[calc(100vh-7.8vw)] overflow-clip lg:mb-[50px]">
				<div className="w-full lg:w-[50vw] px-[25px] lg:pl-[10vw] lg:pr-[5vw] py-[25px] lg:py-0">
					<div className="relative w-[130px] mb-[50px]">
						<h2 className="absolute w-[300px] left-[50%] top-[50%] translate-y-[-50%]">Designed to
							<br></br>
							Inspire
						</h2>
						<img className="" src={SquareFrame}></img>
					</div>
					<p>West58 is brought to you by Azora Group, a proudly family-owned residential development and construction company located in the heart of beautiful Vancouver.</p>
					<br></br>
					<Link to="/team"><h3>Explore Our Team &#8594;</h3></Link>
				</div>
				<div className="hidden lg:block absolute right-0 w-[50vw] h-[300%] top-auto bottom-0">
					<div className="sticky h-[calc(100vh-7.8vw)] top-[7.8vw] flex items-center">
						<img className="sticky top-0" src={Inspire}></img>
					</div>
				</div>
				<div className="lg:hidden relative w-full lg:top-0">
					<div className="absolute w-full top-0 h-[200vh]">
						<div className="sticky top-[18vw]">
							<img className="" src={Inspire}></img>
						</div>
					</div>
				</div>
			</div>
			<div className="hidden lg:block absolute w-[10vw] top-0 bottom-0 flex justify-center items-center">
				<div className="sticky top-0 h-[calc(100vh-7.8vw)] flex justify-center items center pt-[calc((100vh-7.8vw)/2)]">
					<div className="h-[131px]">
						<img className="" src={ActiveDot}></img>
						<img className="py-[10px]" src={Dot}></img>
						<img className="" src={Dot}></img>
					</div>
				</div>
			</div>
		</div>
		<MainSiteFooter />
	</div>
  );
};

export default Home;
